/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.client.TextureSetMap;
import hunternif.mc.atlas.util.AbstractJSONConfig;
import hunternif.mc.atlas.util.Log;
import java.io.File;
import java.util.Map;
import java.util.PriorityQueue;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureSetConfig
extends AbstractJSONConfig<TextureSetMap> {
    private static final int VERSION = 1;

    public TextureSetConfig(File file) {
        super(file);
    }

    @Override
    public int currentVersion() {
        return 1;
    }

    @Override
    protected void loadData(JsonObject json, TextureSetMap data, int version) {
        for (Map.Entry entry : json.entrySet()) {
            String name = (String)entry.getKey();
            JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
            ResourceLocation[] textures = new ResourceLocation[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                String path = array.get(i).getAsString();
                textures[i] = new ResourceLocation(path);
            }
            data.register(new TextureSet(name, textures));
            Log.info("Loaded texture set %s with %d custom texture(s)", name, textures.length);
        }
    }

    @Override
    protected void saveData(JsonObject json, TextureSetMap data) {
        PriorityQueue<TextureSet> queue = new PriorityQueue<TextureSet>(data.getAllNonStandardTextureSets());
        while (!queue.isEmpty()) {
            TextureSet set = (TextureSet)queue.poll();
            JsonArray paths = new JsonArray();
            for (ResourceLocation texture : set.textures) {
                paths.add((JsonElement)new JsonPrimitive(texture.toString()));
            }
            json.add(set.name, (JsonElement)paths);
        }
    }
}

