/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenShrub;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.world.underground.BasicUndergroundBiome;

public class UndergroundBiomeLush
extends BasicUndergroundBiome {
    WorldGenShrub shrubGen = new WorldGenShrub(Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P());
    int grassChance;
    int shrubChance;
    int vineChance;

    public UndergroundBiomeLush() {
        super(Blocks.field_150349_c.func_176223_P(), null, null);
    }

    @Override
    public void finalFloorPass(World world, BlockPos pos) {
        if (this.grassChance > 0 && world.field_73012_v.nextInt(this.grassChance) == 0) {
            ItemDye.func_179234_a((ItemStack)new ItemStack(Items.field_151100_aR, 1, 14), (World)world, (BlockPos)pos);
        }
        if (this.shrubChance > 0 && world.field_73012_v.nextInt(this.shrubChance) == 0) {
            this.shrubGen.func_180709_b(world, world.field_73012_v, pos.func_177984_a());
        }
    }

    @Override
    public void finalWallPass(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos off = pos.func_177972_a(facing);
            BlockPos up = off.func_177984_a();
            if (this.vineChance <= 0 || !this.isCeiling(world, up, world.func_180495_p(up)) || world.field_73012_v.nextInt(this.vineChance) != 0) continue;
            IBlockState stateAt = world.func_180495_p(off);
            boolean did = false;
            while (stateAt.func_177230_c().isAir(stateAt, (IBlockAccess)world, off)) {
                world.func_180501_a(off, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.func_176267_a((EnumFacing)facing.func_176734_d()), (Comparable)Boolean.valueOf(true)), 2);
                off = off.func_177977_b();
                stateAt = world.func_180495_p(off);
                did = true;
            }
            if (!did) continue;
            return;
        }
    }

    @Override
    public void setupConfig(String category) {
        this.grassChance = ModuleLoader.config.getInt("Grass Chance", category, 20, 0, Integer.MAX_VALUE, "The higher, the less grass will spawn");
        this.shrubChance = ModuleLoader.config.getInt("Shrub Chance", category, 100, 0, Integer.MAX_VALUE, "The higher, the less shrubs will spawn");
        this.vineChance = ModuleLoader.config.getInt("Vine Chance", category, 8, 0, Integer.MAX_VALUE, "The higher, the less vines will spawn");
    }
}

