/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world.underground;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.feature.RevampStoneGen;

public abstract class UndergroundBiome {
    int dungeonChance;
    int maxDungeons;
    int minDungeons;
    public static final Predicate<IBlockState> STONE_PREDICATE = state -> {
        if (state != null) {
            Block block = state.func_177230_c();
            if (block == Blocks.field_150348_b) {
                BlockStone.EnumType blockstone$enumtype = (BlockStone.EnumType)state.func_177229_b((IProperty)BlockStone.field_176247_a);
                return blockstone$enumtype.func_190912_e();
            }
            return block == RevampStoneGen.limestone || block == RevampStoneGen.marble;
        }
        return false;
    };
    List<BlockPos> floorList;
    List<BlockPos> ceilingList;
    List<BlockPos> insideList;
    Map<BlockPos, EnumFacing> wallMap;

    public boolean apply(World world, BlockPos center, int radiusX, int radiusY, int radiusZ) {
        int centerX = center.func_177958_n();
        int centerY = center.func_177956_o();
        int centerZ = center.func_177952_p();
        double radiusX2 = radiusX * radiusX;
        double radiusY2 = radiusY * radiusY;
        double radiusZ2 = radiusZ * radiusZ;
        this.floorList = new ArrayList<BlockPos>();
        this.ceilingList = new ArrayList<BlockPos>();
        this.insideList = new ArrayList<BlockPos>();
        this.wallMap = new HashMap<BlockPos, EnumFacing>();
        for (int x = -radiusX; x < radiusX + 1; ++x) {
            for (int y = -radiusY; y < radiusY + 1; ++y) {
                for (int z = -radiusZ; z < radiusZ + 1; ++z) {
                    boolean inside;
                    double distX = x * x;
                    double distY = y * y;
                    double distZ = z * z;
                    boolean bl = inside = distX / radiusX2 + distY / radiusY2 + distZ / radiusZ2 <= 1.0;
                    if (!inside) continue;
                    this.fill(world, center.func_177982_a(x, y, z));
                }
            }
        }
        this.floorList.forEach(pos -> this.finalFloorPass(world, (BlockPos)pos));
        this.ceilingList.forEach(pos -> this.finalCeilingPass(world, (BlockPos)pos));
        this.wallMap.keySet().forEach(pos -> this.finalWallPass(world, (BlockPos)pos));
        this.insideList.forEach(pos -> this.finalInsidePass(world, (BlockPos)pos));
        if (this.hasDungeon() && world instanceof WorldServer) {
            int times;
            for (times = this.minDungeons; times < this.maxDungeons && world.field_73012_v.nextInt(this.dungeonChance) == 0; ++times) {
            }
            ArrayList<BlockPos> candidates = new ArrayList<BlockPos>(this.wallMap.keySet());
            candidates.removeIf(pos -> {
                IBlockState state;
                BlockPos down = pos.func_177977_b();
                return this.isWall(world, down, state = world.func_180495_p(down)) || state.func_177230_c().isAir(state, (IBlockAccess)world, down);
            });
            ArrayList<BlockPos> currentDungeons = new ArrayList<BlockPos>();
            for (int i = 0; i < times; ++i) {
                candidates.removeIf(pos -> {
                    for (BlockPos compare : currentDungeons) {
                        if (!(compare.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < (double)this.getDungeonDistance())) continue;
                        return true;
                    }
                    return false;
                });
                if (candidates.isEmpty()) break;
                BlockPos pos2 = (BlockPos)candidates.get(world.field_73012_v.nextInt(candidates.size()));
                currentDungeons.add(pos2);
                candidates.remove(pos2);
                EnumFacing border = this.wallMap.get(pos2);
                if (border == null) continue;
                this.spawnDungeon((WorldServer)world, pos2, border);
            }
        }
        return true;
    }

    public void fill(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().func_176195_g(state, world, pos) == -1.0f || world.func_175710_j(pos)) {
            return;
        }
        if (this.isFloor(world, pos, state)) {
            this.floorList.add(pos);
            this.fillFloor(world, pos, state);
        } else if (this.isCeiling(world, pos, state)) {
            this.ceilingList.add(pos);
            this.fillCeiling(world, pos, state);
        } else if (this.isWall(world, pos, state)) {
            this.wallMap.put(pos, this.getBorderSide(world, pos));
            this.fillWall(world, pos, state);
        } else if (this.isInside(world, pos, state)) {
            this.insideList.add(pos);
            this.fillInside(world, pos, state);
        }
    }

    public abstract void fillFloor(World var1, BlockPos var2, IBlockState var3);

    public abstract void fillCeiling(World var1, BlockPos var2, IBlockState var3);

    public abstract void fillWall(World var1, BlockPos var2, IBlockState var3);

    public abstract void fillInside(World var1, BlockPos var2, IBlockState var3);

    public void finalFloorPass(World world, BlockPos pos) {
    }

    public void finalCeilingPass(World world, BlockPos pos) {
    }

    public void finalWallPass(World world, BlockPos pos) {
    }

    public void finalInsidePass(World world, BlockPos pos) {
    }

    public final void setupBaseConfig(String category) {
        if (this.hasDungeon()) {
            int[] settings = this.getDefaultDungeonSettings();
            this.dungeonChance = ModuleLoader.config.getInt("Dungeon Chance", category, settings[0], 0, Integer.MAX_VALUE, "The chance that dungeons will spawn in this biome. 1 is 100%, 2 is 50%, the higher, the less dungeons will spawn.");
            this.maxDungeons = ModuleLoader.config.getInt("Max Dungeons", category, settings[1], 0, Integer.MAX_VALUE, "The max amount of dungeons that can spawn.");
            this.minDungeons = ModuleLoader.config.getInt("Min Dungeons", category, settings[2], 0, Integer.MAX_VALUE, "The minimum amount of dungeons that will spawn.");
        }
        this.setupConfig(category);
    }

    public void setupConfig(String category) {
    }

    public boolean hasDungeon() {
        return false;
    }

    public int getDungeonDistance() {
        return 0;
    }

    public int[] getDefaultDungeonSettings() {
        return new int[]{2, 2, 0};
    }

    public void spawnDungeon(WorldServer world, BlockPos pos, EnumFacing face) {
    }

    boolean isFloor(World world, BlockPos pos, IBlockState state) {
        if (!state.func_185913_b() || !state.func_185914_p()) {
            return false;
        }
        BlockPos upPos = pos.func_177984_a();
        return world.func_175623_d(upPos) || world.func_180495_p(upPos).func_177230_c().func_176200_f((IBlockAccess)world, upPos);
    }

    boolean isCeiling(World world, BlockPos pos, IBlockState state) {
        if (!state.func_185913_b() || !state.func_185914_p()) {
            return false;
        }
        BlockPos downPos = pos.func_177977_b();
        return world.func_175623_d(downPos) || world.func_180495_p(downPos).func_177230_c().func_176200_f((IBlockAccess)world, downPos);
    }

    boolean isWall(World world, BlockPos pos, IBlockState state) {
        if (!(state.func_185913_b() && state.func_185914_p() && STONE_PREDICATE.apply((Object)state))) {
            return false;
        }
        return this.isBorder(world, pos, state);
    }

    EnumFacing getBorderSide(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            IBlockState stateAt = world.func_180495_p(offsetPos);
            if (!world.func_175623_d(offsetPos) && !stateAt.func_177230_c().func_176200_f((IBlockAccess)world, offsetPos)) continue;
            return facing;
        }
        return null;
    }

    boolean isBorder(World world, BlockPos pos, IBlockState state) {
        return this.getBorderSide(world, pos) != null;
    }

    boolean isInside(World world, BlockPos pos, IBlockState state) {
        return STONE_PREDICATE.apply((Object)state);
    }

    public static Rotation rotationFromFacing(EnumFacing facing) {
        switch (facing) {
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }
}

