/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import vazkii.quark.base.handler.BiomeTypeConfigHandler;
import vazkii.quark.world.feature.RevampStoneGen;

public class StoneInfoBasedGenerator {
    public Supplier<RevampStoneGen.StoneInfo> infoSupplier;
    public String name;
    WorldGenMinable generator;
    long seedXor;
    boolean lock;

    public StoneInfoBasedGenerator(Supplier<RevampStoneGen.StoneInfo> infoSupplier, IBlockState state, String name) {
        this.infoSupplier = infoSupplier;
        this.name = name;
        this.generator = new WorldGenMinable(state, infoSupplier.get().clusterSize);
        this.seedXor = name.hashCode();
    }

    public void generate(int chunkX, int chunkZ, World world) {
        if (this.lock) {
            return;
        }
        RevampStoneGen.StoneInfo info = this.infoSupplier.get();
        if (!info.enabled || !info.dims.canSpawnHere(world)) {
            return;
        }
        Random rand = new Random(world.func_72905_C());
        long xSeed = rand.nextLong() >> 3;
        long zSeed = rand.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ world.func_72905_C() ^ this.seedXor;
        rand.setSeed(chunkSeed);
        int amount = 1;
        int chance = info.clusterRarity;
        if (info.clustersRarityPerChunk) {
            chance = 1;
            amount = info.clusterRarity;
        }
        int lower = Math.abs(info.lowerBound);
        int range = Math.abs(info.upperBound - info.lowerBound);
        if (rand.nextInt(chance) == 0) {
            this.lock = true;
            for (int i = 0; i < amount; ++i) {
                Biome biome;
                int x = chunkX * 16 + rand.nextInt(16) + 8;
                int y = rand.nextInt(range) + lower;
                int z = chunkZ * 16 + rand.nextInt(16) + 8;
                BlockPos pos = new BlockPos(x, y, z);
                if (RevampStoneGen.generateBasedOnBiomes && !this.canGenerateInBiome(info, biome = world.func_180494_b(pos))) continue;
                this.generator.func_180709_b(world, rand, pos);
            }
            this.lock = false;
        }
    }

    public boolean canGenerateInBiome(Biome b) {
        return this.canGenerateInBiome(this.infoSupplier.get(), b);
    }

    public boolean canGenerateInBiome(RevampStoneGen.StoneInfo info, Biome b) {
        return BiomeTypeConfigHandler.biomeTypeIntersectCheck(info.allowedBiomes, b);
    }
}

