/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.List;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.potion.PotionMod;
import vazkii.quark.world.client.render.RenderWraith;
import vazkii.quark.world.entity.EntityWraith;
import vazkii.quark.world.item.ItemSoulBead;

public class Wraiths
extends Feature {
    public static Item soul_bead;
    public static Potion curse;
    public static int curseTime;
    public static boolean enableCurse;
    int weight;
    int min;
    int max;
    int curseRange;

    @Override
    public void setupConfig() {
        this.weight = this.loadPropInt("Spawn Weight", "", 60);
        this.min = this.loadPropInt("Smallest spawn group", "", 4);
        this.max = this.loadPropInt("Largest spawn group", "", 6);
        this.curseRange = this.loadPropInt("Curse Range", "", 64);
        curseTime = this.loadPropInt("Curse Time", "How long the curse effect lasts for (in ticks)", 24000);
        enableCurse = this.loadPropBool("Enable Curse", "", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        soul_bead = new ItemSoulBead();
        if (enableCurse) {
            curse = new PotionMod("curse", true, 0, 0);
        }
        String wraithName = "quark:wraith";
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(wraithName), EntityWraith.class, (String)wraithName, (int)4, (Object)Quark.instance, (int)80, (int)3, (boolean)true, (int)0xECECEC, (int)0xBDBDBD);
        EntityRegistry.addSpawn(EntityWraith.class, (int)this.weight, (int)this.min, (int)this.max, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER).toArray(new Biome[0]));
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityWraith.class, (IRenderFactory)RenderWraith.FACTORY);
    }

    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() != Event.Result.ALLOW && event.getEntityLiving() instanceof IMob && event.getWorld() instanceof WorldServer) {
            List players = ((WorldServer)event.getWorld()).field_73010_i;
            for (EntityPlayer player : players) {
                if (player.func_70660_b(curse) == null || !(player.func_70068_e(event.getEntity()) < (double)(this.curseRange * this.curseRange))) continue;
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, false, false));
                event.setResult(Event.Result.ALLOW);
                return;
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

