/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.feature;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.Feature;
import vazkii.quark.world.client.render.RenderAshen;
import vazkii.quark.world.client.render.RenderDweller;
import vazkii.quark.world.entity.EntityAshen;
import vazkii.quark.world.entity.EntityDweller;

public class DepthMobs
extends Feature {
    public static int upperBound;
    boolean enableAshen;
    boolean enableDweller;
    int ashenWeight;
    int dwellerWeight;
    int ashenMaxPack;
    int dwellerMaxPack;
    int ashenMinPack;
    int dwellerMinPack;

    @Override
    public void setupConfig() {
        upperBound = this.loadPropInt("Highest Y level for spawns", "", 20);
        this.enableAshen = this.loadPropBool("Enable Ashen", "", true);
        this.enableDweller = this.loadPropBool("Enable Dweller", "", true);
        this.ashenWeight = this.loadPropInt("Ashen Spawn Weight", "(Skeleton is 100)", 10);
        this.dwellerWeight = this.loadPropInt("Dweller Spawn Weight", "(Zombie is 100)", 10);
        this.ashenMaxPack = this.loadPropInt("Largest Ashen spawn group", "", 2);
        this.dwellerMaxPack = this.loadPropInt("Largest Dweller spawn group", "", 2);
        this.ashenMinPack = this.loadPropInt("Smallest Ashen spawn group", "", 1);
        this.dwellerMinPack = this.loadPropInt("Smallest Dweller spawn group", "", 1);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (this.enableDweller) {
            String dwellerName = "quark:dweller";
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(dwellerName), EntityDweller.class, (String)dwellerName, (int)2, (Object)Quark.instance, (int)80, (int)3, (boolean)true, (int)4872516, (int)4136992);
            EntityRegistry.addSpawn(EntityDweller.class, (int)this.dwellerWeight, (int)this.dwellerMinPack, (int)this.dwellerMaxPack, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])this.getBiomesWithMob(EntityZombie.class));
        }
        if (this.enableAshen) {
            String ashenName = "quark:ashen";
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(ashenName), EntityAshen.class, (String)ashenName, (int)1, (Object)Quark.instance, (int)80, (int)3, (boolean)true, (int)8618870, (int)5455164);
            EntityRegistry.addSpawn(EntityAshen.class, (int)this.ashenWeight, (int)this.ashenMinPack, (int)this.ashenMaxPack, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])this.getBiomesWithMob(EntitySkeleton.class));
        }
    }

    @Override
    public void preInitClient(FMLPreInitializationEvent event) {
        if (this.enableDweller) {
            RenderingRegistry.registerEntityRenderingHandler(EntityDweller.class, (IRenderFactory)RenderDweller.FACTORY);
        }
        if (this.enableAshen) {
            RenderingRegistry.registerEntityRenderingHandler(EntityAshen.class, (IRenderFactory)RenderAshen.FACTORY);
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    private Biome[] getBiomesWithMob(Class<? extends Entity> clazz) {
        ArrayList<Biome> biomes = new ArrayList<Biome>();
        block0: for (Biome b : Biome.field_185377_q) {
            List spawnList = b.func_76747_a(EnumCreatureType.MONSTER);
            for (Biome.SpawnListEntry e : spawnList) {
                if (e.field_76300_b != clazz) continue;
                biomes.add(b);
                continue block0;
            }
        }
        return biomes.toArray(new Biome[biomes.size()]);
    }
}

