/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.feature;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.aurelienribon.tweenengine.Tween;
import vazkii.quark.base.client.ModKeybinds;
import vazkii.quark.base.client.gui.GuiButtonTranslucent;
import vazkii.quark.base.module.Feature;
import vazkii.quark.vanity.client.emotes.EmoteCheer;
import vazkii.quark.vanity.client.emotes.EmoteClap;
import vazkii.quark.vanity.client.emotes.EmoteCustom;
import vazkii.quark.vanity.client.emotes.EmoteFacepalm;
import vazkii.quark.vanity.client.emotes.EmoteHeadbang;
import vazkii.quark.vanity.client.emotes.EmoteNo;
import vazkii.quark.vanity.client.emotes.EmotePoint;
import vazkii.quark.vanity.client.emotes.EmoteSalute;
import vazkii.quark.vanity.client.emotes.EmoteShrug;
import vazkii.quark.vanity.client.emotes.EmoteWave;
import vazkii.quark.vanity.client.emotes.EmoteYes;
import vazkii.quark.vanity.client.emotes.base.EmoteBase;
import vazkii.quark.vanity.client.emotes.base.EmoteDescriptor;
import vazkii.quark.vanity.client.emotes.base.EmoteHandler;
import vazkii.quark.vanity.client.emotes.base.ModelAccessor;
import vazkii.quark.vanity.client.gui.GuiButtonEmote;
import vazkii.quark.vanity.command.CommandEmote;

public class EmoteSystem
extends Feature {
    private static final int EMOTE_BUTTON_START = 1800;
    static boolean emotesVisible = false;
    private boolean enableKeybinds;
    private boolean enableCustomEmote;

    @Override
    public void setupConfig() {
        this.enableKeybinds = this.loadPropBool("Enable Keybinds", "Should keybinds for emotes be generated? (They're all unbound by default)", true);
        this.enableCustomEmote = this.loadPropBool("Enable Custom Emote", "Allows usage of a custom emote. EXPERIMENTAL, do not use if you don't know exactly what you're doing!", false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        Tween.registerAccessor(ModelBiped.class, new ModelAccessor());
        EmoteHandler.addEmote("wave", EmoteWave.class);
        EmoteHandler.addEmote("salute", EmoteSalute.class);
        EmoteHandler.addEmote("yes", EmoteYes.class);
        EmoteHandler.addEmote("no", EmoteNo.class);
        EmoteHandler.addEmote("cheer", EmoteCheer.class);
        EmoteHandler.addEmote("clap", EmoteClap.class);
        EmoteHandler.addEmote("point", EmotePoint.class);
        EmoteHandler.addEmote("shrug", EmoteShrug.class);
        EmoteHandler.addEmote("facepalm", EmoteFacepalm.class);
        EmoteHandler.addEmote("headbang", EmoteHeadbang.class);
        if (this.enableCustomEmote) {
            EmoteHandler.addEmote("custom", EmoteCustom.class);
        }
        if (this.enableKeybinds) {
            ModKeybinds.initEmoteKeybinds();
        }
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandEmote());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.getGui();
        if (gui instanceof GuiChat) {
            List list = event.getButtonList();
            list.add(new GuiButtonTranslucent(1800, gui.field_146294_l - 100, gui.field_146295_m - 40, 100, 20, I18n.func_135052_a((String)"quark.gui.emotes", (Object[])new Object[0])));
            int size = EmoteHandler.emoteMap.size() - 1;
            for (String key : EmoteHandler.emoteMap.keySet()) {
                EmoteDescriptor desc = EmoteHandler.emoteMap.get(key);
                int i = desc.index;
                int x = gui.field_146294_l - 100;
                int y = gui.field_146295_m - 61 - 21 * (size - i);
                GuiButtonEmote button = new GuiButtonEmote(1800 + i + 1, x, y, desc);
                button.field_146125_m = emotesVisible;
                button.field_146124_l = emotesVisible;
                list.add(button);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void performAction(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        GuiButton button = event.getButton();
        if (button.field_146127_k == 1800) {
            event.getGui();
            List list = event.getButtonList();
            for (GuiButton b : list) {
                if (!(b instanceof GuiButtonEmote)) continue;
                b.field_146125_m = !b.field_146125_m;
                b.field_146124_l = !b.field_146124_l;
            }
            emotesVisible = !emotesVisible;
        } else if (button instanceof GuiButtonEmote) {
            String cmd = ((GuiButtonEmote)button).desc.getCommand();
            Minecraft.func_71410_x().field_71439_g.func_71165_d(cmd);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71415_G && this.enableKeybinds) {
            for (KeyBinding key : ModKeybinds.emoteKeys.keySet()) {
                if (!key.func_151470_d()) continue;
                String emote = ModKeybinds.emoteKeys.get(key);
                mc.field_71439_g.func_71165_d("/emote " + emote);
                return;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = event.getResolution();
            EmoteBase emote = EmoteHandler.getPlayerEmote((EntityPlayer)mc.field_71439_g);
            if (emote != null && emote.timeDone < emote.totalTime) {
                ResourceLocation resource = emote.desc.texture;
                int x = res.func_78326_a() / 2 - 16;
                int y = res.func_78328_b() / 2 - 60;
                float transparency = 1.0f;
                float tween = 5.0f;
                if (emote.timeDone < tween) {
                    transparency = emote.timeDone / tween;
                } else if (emote.timeDone > emote.totalTime - tween) {
                    transparency = (emote.totalTime - emote.timeDone) / tween;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                mc.func_110434_K().func_110577_a(resource);
                GuiScreen.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
                GlStateManager.func_179147_l();
                String name = I18n.func_135052_a((String)emote.desc.getUnlocalizedName(), (Object[])new Object[0]);
                mc.field_71466_p.func_175063_a(name, (float)(res.func_78326_a() / 2 - mc.field_71466_p.func_78256_a(name) / 2), (float)(y + 34), 0xFFFFFF + ((int)(transparency * 255.0f) << 24));
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderTick(TickEvent.RenderTickEvent event) {
        EmoteHandler.onRenderTick(Minecraft.func_71410_x(), event.phase == TickEvent.Phase.START);
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

