/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emotes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.FMLLog;
import vazkii.aurelienribon.tweenengine.Timeline;
import vazkii.aurelienribon.tweenengine.Tween;
import vazkii.quark.vanity.client.emotes.base.EmoteBase;
import vazkii.quark.vanity.client.emotes.base.EmoteDescriptor;

public class EmoteCustom
extends EmoteBase {
    private static final Map<String, Integer> parts = new HashMap<String, Integer>();
    private static final Map<String, Integer> tweenables = new HashMap<String, Integer>();
    private static final Map<String, Function> functions = new HashMap<String, Function>();
    List<Integer> usedParts;
    Stack<Timeline> timelineStack;
    boolean compiled = false;

    public EmoteCustom(EmoteDescriptor desc, EntityPlayer player, ModelBiped model, ModelBiped armorModel, ModelBiped armorLegsModel) {
        super(desc, player, model, armorModel, armorLegsModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timeline getTimeline(EntityPlayer player, ModelBiped model) {
        BufferedReader reader;
        this.usedParts = new ArrayList<Integer>();
        this.timelineStack = new Stack();
        this.compiled = false;
        try {
            reader = new BufferedReader(new FileReader(new File(".", "emote.txt")));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        Timeline timeline = null;
        int lines = 0;
        try {
            Timeline timeline2;
            try {
                String s;
                while ((s = reader.readLine()) != null && !this.compiled) {
                    ++lines;
                    timeline = this.handle(model, timeline, s);
                }
            }
            catch (Exception e) {
                FMLLog.log.error("[Quark Custom Emotes] Error loading line " + lines);
                if (!(e instanceof IllegalArgumentException)) {
                    FMLLog.log.error("[Quark Custom Emotes] This is an Internal Error, and not one in the emote file, please report it");
                    e.printStackTrace();
                } else {
                    FMLLog.log.error("[Quark Custom Emotes] " + e.getMessage());
                }
                Timeline timeline3 = Timeline.createSequence();
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return timeline3;
            }
            if (timeline == null) {
                timeline2 = Timeline.createSequence();
                return timeline2;
            }
            timeline2 = timeline;
            return timeline2;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Timeline handle(ModelBiped model, Timeline timeline, String s) throws IllegalArgumentException {
        if ((s = s.trim().toLowerCase()).startsWith("#") || s.isEmpty()) {
            return timeline;
        }
        String[] tokens = s.trim().split(" ");
        String function = tokens[0];
        if (functions.containsKey(function)) {
            return functions.get(function).invoke(this, model, timeline, tokens);
        }
        throw new IllegalArgumentException("Illegal function name " + function);
    }

    private static Timeline use(EmoteCustom em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteCustom.assertParamSize(tokens, 2);
        String part = tokens[1];
        if (!parts.containsKey(part)) {
            throw new IllegalArgumentException("Illgal part name for function use: " + part);
        }
        em.usedParts.add(parts.get(part));
        return timeline;
    }

    private static Timeline animation(EmoteCustom em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        String type;
        if (timeline != null) {
            throw new IllegalArgumentException("Illegal use of function animation, animation already started");
        }
        EmoteCustom.assertParamSize(tokens, 2);
        switch (type = tokens[1]) {
            case "sequence": {
                return Timeline.createSequence();
            }
            case "parallel": {
                return Timeline.createParallel();
            }
        }
        throw new IllegalArgumentException("Illegal animation type: " + type);
    }

    private static Timeline section(EmoteCustom em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        Timeline newTimeline;
        String type;
        EmoteCustom.assertParamSize(tokens, 2);
        switch (type = tokens[1]) {
            case "sequence": {
                newTimeline = Timeline.createSequence();
                break;
            }
            case "parallel": {
                newTimeline = Timeline.createParallel();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal section type: " + type);
            }
        }
        em.timelineStack.push(timeline);
        return newTimeline;
    }

    private static Timeline end(EmoteCustom em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteCustom.assertParamSize(tokens, 1);
        if (em.timelineStack.isEmpty()) {
            em.compiled = true;
            return timeline;
        }
        Timeline poppedLine = em.timelineStack.pop();
        poppedLine.push(timeline);
        return poppedLine;
    }

    private static Timeline move(EmoteCustom em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        if (tokens.length < 4) {
            throw new IllegalArgumentException(String.format("Illgal parameter amount for function move: %d (at least 4 are required)", tokens.length));
        }
        String partStr = tokens[1];
        if (!tweenables.containsKey(partStr)) {
            throw new IllegalArgumentException("Illgal part name for function move: " + partStr);
        }
        int part = tweenables.get(partStr);
        int time = Integer.parseInt(tokens[2]);
        double target = Double.parseDouble(tokens[3]);
        Tween tween = Tween.to(model, part, time).target((float)target);
        if (tokens.length > 4) {
            int index = 4;
            block10: while (index < tokens.length) {
                String cmd;
                switch (cmd = tokens[index++]) {
                    case "delay": {
                        EmoteCustom.assertParamSize("delay", tokens, 1, index);
                        int delay = Integer.parseInt(tokens[index++]);
                        tween = (Tween)tween.delay(delay);
                        continue block10;
                    }
                    case "yoyo": {
                        EmoteCustom.assertParamSize("yoyo", tokens, 2, index);
                        int times = Integer.parseInt(tokens[index++]);
                        int delay = Integer.parseInt(tokens[index++]);
                        tween = (Tween)tween.repeatYoyo(times, delay);
                        continue block10;
                    }
                    case "repeat": {
                        EmoteCustom.assertParamSize("repeat", tokens, 2, index);
                        int times = Integer.parseInt(tokens[index++]);
                        int delay = Integer.parseInt(tokens[index++]);
                        tween = (Tween)tween.repeat(times, delay);
                        continue block10;
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid modifier %s for move function", cmd));
            }
        }
        return timeline.push(tween);
    }

    private static Timeline pause(EmoteCustom em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteCustom.assertParamSize(tokens, 2);
        int ms = Integer.parseInt(tokens[1]);
        return timeline.pushPause(ms);
    }

    private static Timeline yoyo(EmoteCustom em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteCustom.assertParamSize(tokens, 3);
        int times = Integer.parseInt(tokens[1]);
        int delay = Integer.parseInt(tokens[2]);
        return (Timeline)timeline.repeatYoyo(times, delay);
    }

    private static Timeline repeat(EmoteCustom em, ModelBiped model, Timeline timeline, String[] tokens) throws IllegalArgumentException {
        EmoteCustom.assertParamSize(tokens, 3);
        int times = Integer.parseInt(tokens[1]);
        int delay = Integer.parseInt(tokens[2]);
        return (Timeline)timeline.repeat(times, delay);
    }

    private static void assertParamSize(String[] tokens, int expect) throws IllegalArgumentException {
        if (tokens.length != expect) {
            throw new IllegalArgumentException(String.format("Illgal parameter amount for function %s: %d (expected %d)", tokens[0], tokens.length, expect));
        }
    }

    private static void assertParamSize(String mod, String[] tokens, int expect, int startingFrom) throws IllegalArgumentException {
        if (tokens.length - startingFrom < expect) {
            throw new IllegalArgumentException(String.format("Illgal parameter amount for move modifier %s: %d (expected at least %d)", mod, tokens.length, expect));
        }
    }

    @Override
    public boolean usesBodyPart(int part) {
        return this.usedParts.contains(part);
    }

    static {
        parts.put("head", 0);
        parts.put("body", 3);
        parts.put("right_arm", 6);
        parts.put("left_arm", 9);
        parts.put("right_leg", 15);
        parts.put("left_leg", 18);
        tweenables.put("head_x", 0);
        tweenables.put("head_y", 1);
        tweenables.put("head_z", 2);
        tweenables.put("body_x", 3);
        tweenables.put("body_y", 4);
        tweenables.put("body_z", 5);
        tweenables.put("right_arm_x", 6);
        tweenables.put("right_arm_y", 7);
        tweenables.put("right_arm_z", 8);
        tweenables.put("left_arm_x", 9);
        tweenables.put("left_arm_y", 10);
        tweenables.put("left_arm_z", 11);
        tweenables.put("right_leg_x", 15);
        tweenables.put("right_leg_y", 16);
        tweenables.put("right_leg_z", 17);
        tweenables.put("left_leg_x", 18);
        tweenables.put("left_leg_y", 19);
        tweenables.put("left_leg_z", 20);
        functions.put("use", EmoteCustom::use);
        functions.put("animation", EmoteCustom::animation);
        functions.put("section", EmoteCustom::section);
        functions.put("end", EmoteCustom::end);
        functions.put("move", EmoteCustom::move);
        functions.put("pause", EmoteCustom::pause);
        functions.put("yoyo", EmoteCustom::yoyo);
        functions.put("repeat", EmoteCustom::repeat);
    }

    private static interface Function {
        public Timeline invoke(EmoteCustom var1, ModelBiped var2, Timeline var3, String[] var4) throws IllegalArgumentException;
    }
}

