/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;

public class EndermenAntiCheese
extends Feature {
    int minimumDifficulty = 2;
    boolean oldBehaviour;
    int delay;
    int lowerBound;
    boolean ignoreMobGriefing;

    @Override
    public void setupConfig() {
        this.minimumDifficulty = this.loadPropInt("Minimum Difficulty", "The minimum difficulty in which this effect should take place. (1: easy, 2: normal, 3: hard)", 2);
        this.oldBehaviour = this.loadPropBool("Use Old Behaviour", "Set this to true to use the old behaviour, where the endermen would teleport the player to them", false);
        this.delay = this.loadPropInt("Delay", "The delay between how often an enderman can break a block.", 10);
        this.lowerBound = this.loadPropInt("HP Lower Bound", "A value of health for which endermen will stop doing anti-cheese when below. Set to 0 to disable.", 3);
        this.ignoreMobGriefing = this.loadPropBool("Ignore mobGriefing Gamerule", "", true);
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityEnderman && event.getEntityLiving().func_130014_f_().func_175659_aa().func_151525_a() >= this.minimumDifficulty) {
            EntityEnderman entity = (EntityEnderman)event.getEntityLiving();
            if (entity.func_110143_aJ() < (float)this.lowerBound) {
                return;
            }
            BlockPos ourPos = entity.func_180425_c().func_177981_b(2);
            IBlockState ourState = entity.func_130014_f_().func_180495_p(ourPos);
            Block ourBlock = ourState.func_177230_c();
            if (ourBlock.func_180646_a(ourState, (IBlockAccess)entity.func_130014_f_(), ourPos) != null) {
                return;
            }
            EntityLivingBase target = entity.func_70638_az();
            if (target != null && target instanceof EntityPlayer && target.field_70122_E) {
                BlockPos pos = target.func_180425_c().func_177981_b(2);
                if (pos.func_185332_f(ourPos.func_177958_n(), ourPos.func_177956_o(), ourPos.func_177952_p()) > 5.0) {
                    return;
                }
                if (this.oldBehaviour) {
                    this.teleportPlayer(entity, target, pos);
                } else {
                    this.pickupDefense(entity, target, ourPos);
                }
            }
        }
    }

    private void teleportPlayer(EntityEnderman entity, EntityLivingBase target, BlockPos pos) {
        IBlockState state = entity.func_130014_f_().func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.func_180646_a(state, (IBlockAccess)entity.func_130014_f_(), pos) != null) {
            for (int i = 0; i < 16 && !target.func_184595_k(entity.field_70165_t + (Math.random() - 0.5) * 2.0, entity.field_70163_u + 0.5, entity.field_70161_v + (Math.random() - 0.5) * 2.0); ++i) {
            }
            target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 30, 0));
            target.func_130014_f_().func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187532_aV, SoundCategory.HOSTILE, 1.0f, 1.0f);
            target.func_130014_f_().func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
    }

    private void pickupDefense(EntityEnderman entity, EntityLivingBase target, BlockPos pos) {
        boolean unbreakable;
        if (entity.field_70173_aa % this.delay != 0 && (this.ignoreMobGriefing || !entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing"))) {
            return;
        }
        Vec3d look = entity.func_70040_Z();
        pos = pos.func_177982_a((int)(look.field_72450_a * 1.2), 0, (int)(look.field_72449_c * 1.2));
        entity.func_184609_a(EnumHand.MAIN_HAND);
        IBlockState state = entity.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean bl = unbreakable = block.func_176195_g(state, entity.field_70170_p, pos) == -1.0f || !block.canEntityDestroy(state, (IBlockAccess)entity.field_70170_p, pos, (Entity)entity);
        if (!unbreakable && block.func_180646_a(state, (IBlockAccess)entity.func_130014_f_(), pos) != null) {
            List drops = block.getDrops((IBlockAccess)entity.field_70170_p, pos, state, 0);
            entity.field_70170_p.func_175698_g(pos);
            entity.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            for (ItemStack drop : drops) {
                entity.field_70170_p.func_72838_d((Entity)new EntityItem(entity.field_70170_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop));
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

