/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import vazkii.quark.base.module.Feature;

public class AutomaticRecipeUnlock
extends Feature {
    List<String> ignored;
    boolean forceLimitedCrafting;

    @Override
    public void setupConfig() {
        String[] ignoredArr = this.loadPropStringList("Ignored Recipes", "A list of recipe names that should NOT be added in by default", new String[0]);
        this.ignored = Arrays.asList(ignoredArr);
        this.forceLimitedCrafting = this.loadPropBool("Force Limited Crafting", "Set to true to force the doLimitedCrafting gamerule to true.\nCombine this with the Ignored Recipes list to create a system where only a few selected recipes are locked.", false);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            ArrayList recipes = Lists.newArrayList((Iterable)CraftingManager.field_193380_a);
            recipes.removeIf(recipe -> this.ignored.contains(recipe.getRegistryName().toString()));
            ((EntityPlayerMP)event.player).func_192021_a((List)recipes);
            if (this.forceLimitedCrafting) {
                event.player.field_70170_p.func_82736_K().func_82764_b("doLimitedCrafting", "true");
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

