/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import net.minecraft.block.BlockSkull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.quark.base.module.Feature;

public class NoteBlocksMobSounds
extends Feature {
    public static final EnumFacing[] SKULL_SERACH_FACINGS = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};

    @SubscribeEvent
    public void noteBlockPlayed(NoteBlockEvent.Play event) {
        BlockPos pos = event.getPos();
        if (event.getWorld().func_180495_p(pos).func_177230_c() != Blocks.field_150323_B) {
            return;
        }
        int type = NoteBlocksMobSounds.getSkullType(event.getWorld(), pos);
        if (type != -1 && type != 3) {
            event.setCanceled(true);
            SoundEvent sound = null;
            switch (type) {
                case 0: {
                    sound = SoundEvents.field_187854_fc;
                    break;
                }
                case 1: {
                    sound = SoundEvents.field_190036_ha;
                    break;
                }
                case 2: {
                    sound = SoundEvents.field_187899_gZ;
                    break;
                }
                case 4: {
                    sound = SoundEvents.field_187572_ar;
                    break;
                }
                case 5: {
                    sound = SoundEvents.field_187521_aK;
                }
            }
            if (sound != null) {
                float pitch = (float)Math.pow(2.0, (double)(event.getVanillaNoteId() - 12) / 12.0);
                event.getWorld().func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, sound, SoundCategory.BLOCKS, 1.0f, pitch);
            }
        }
    }

    public static int getSkullType(World world, BlockPos pos) {
        TileEntity tile = null;
        boolean can = false;
        for (EnumFacing face : SKULL_SERACH_FACINGS) {
            IBlockState state;
            BlockPos apos = pos.func_177972_a(face);
            tile = world.func_175625_s(apos);
            if (tile == null || !(tile instanceof TileEntitySkull) || (state = world.func_180495_p(apos)).func_177229_b((IProperty)BlockSkull.field_176418_a) != face) continue;
            can = true;
            break;
        }
        if (can && tile != null) {
            int type = ((TileEntitySkull)tile).func_145904_a();
            return type;
        }
        return -1;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

