/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.misc.feature;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.quark.base.client.ModKeybinds;
import vazkii.quark.base.module.Feature;

public class AutoJumpHotkey
extends Feature {
    private static final float DISPLAY_TIME = 10.0f;
    private static final float FADE_TIME = 10.0f;
    private static final float TOTAL_TIME = 20.0f;
    private static final ResourceLocation AUTOJUMP_OFF = new ResourceLocation("quark", "textures/misc/autojump_off.png");
    private static final ResourceLocation AUTOJUMP_ON = new ResourceLocation("quark", "textures/misc/autojump_on.png");
    int hudTime;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient(FMLPreInitializationEvent event) {
        ModKeybinds.initAutoJumpKey();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean down = ModKeybinds.autoJumpKey.func_151470_d();
        if (mc.field_71415_G && down) {
            boolean b = mc.field_71474_y.func_74308_b(GameSettings.Options.AUTO_JUMP);
            int i = b ? 1 : 0;
            mc.field_71474_y.func_74306_a(GameSettings.Options.AUTO_JUMP, ~i & 1);
            this.hudTime = 20;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.hudTime > 0) {
            --this.hudTime;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL || this.hudTime == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = event.getResolution();
        int x = res.func_78326_a() / 2 - 16;
        int y = res.func_78328_b() - 100;
        boolean autojumpEnabled = mc.field_71474_y.func_74308_b(GameSettings.Options.AUTO_JUMP);
        Math.min(10.0f, (float)this.hudTime + 10.0f);
        float alpha = ((float)this.hudTime + event.getPartialTicks()) / 10.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        mc.field_71446_o.func_110577_a(autojumpEnabled ? AUTOJUMP_ON : AUTOJUMP_OFF);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)32, (int)32, (float)32.0f, (float)32.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean hasSubscriptions() {
        return this.isClient();
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }
}

