/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.decoration.feature.VariedChests;
import vazkii.quark.decoration.item.ItemChestBlock;
import vazkii.quark.decoration.tile.TileCustomChest;

public class BlockCustomChest
extends BlockChest
implements IQuarkBlock {
    private final String[] variants;
    private final String bareName;

    public BlockCustomChest(String name, BlockChest.Type type) {
        super(type);
        this.variants = new String[]{name};
        this.bareName = name;
        this.func_149663_c(name);
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(type == VariedChests.CUSTOM_TYPE_QUARK_TRAP ? CreativeTabs.field_78028_d : CreativeTabs.field_78031_c);
    }

    public Block func_149663_c(String name) {
        super.func_149663_c(name);
        this.setRegistryName("quark:" + name);
        ProxyRegistry.register((IForgeRegistryEntry)this);
        ProxyRegistry.register((IForgeRegistryEntry)new ItemChestBlock((Block)this, new ResourceLocation("quark:" + name)));
        return this;
    }

    public String getBareName() {
        return this.bareName;
    }

    public String[] getVariants() {
        return this.variants;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getCustomMeshDefinition() {
        return null;
    }

    public EnumRarity getBlockRarity(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public IProperty[] getIgnoredProperties() {
        return this.func_180661_e().func_177623_d().toArray(new IProperty[0]);
    }

    public IProperty getVariantProp() {
        return null;
    }

    public Class getVariantEnum() {
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        VariedChests.ChestType myType = this.getCustomType(source, pos);
        return this.getCustomType(source, pos.func_177978_c()) == myType ? field_185557_b : (this.getCustomType(source, pos.func_177968_d()) == myType ? field_185558_c : (this.getCustomType(source, pos.func_177976_e()) == myType ? field_185559_d : (this.getCustomType(source, pos.func_177974_f()) == myType ? field_185560_e : field_185561_f)));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176459_a, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        boolean eastChest;
        EnumFacing facing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)field_176459_a, (Comparable)facing);
        BlockPos northPos = pos.func_177978_c();
        BlockPos southPos = pos.func_177968_d();
        BlockPos westPos = pos.func_177976_e();
        BlockPos eastPos = pos.func_177974_f();
        VariedChests.ChestType myType = this.getCustomType(stack);
        boolean northChest = myType == this.getCustomType((IBlockAccess)worldIn, northPos);
        boolean southChest = myType == this.getCustomType((IBlockAccess)worldIn, southPos);
        boolean westChest = myType == this.getCustomType((IBlockAccess)worldIn, westPos);
        boolean bl = eastChest = myType == this.getCustomType((IBlockAccess)worldIn, eastPos);
        if (!(northChest || southChest || westChest || eastChest)) {
            worldIn.func_180501_a(pos, state, 3);
        } else if (facing.func_176740_k() != EnumFacing.Axis.X || !northChest && !southChest) {
            if (facing.func_176740_k() == EnumFacing.Axis.Z && (westChest || eastChest)) {
                if (westChest) {
                    this.setState(worldIn, westPos, state, 3);
                } else {
                    this.setState(worldIn, eastPos, state, 3);
                }
                worldIn.func_180501_a(pos, state, 3);
            } else {
                EnumFacing corrected = facing.func_176746_e();
                this.setState(worldIn, pos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                if (northChest) {
                    this.setState(worldIn, northPos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                } else if (southChest) {
                    this.setState(worldIn, southPos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                } else if (westChest) {
                    this.setState(worldIn, westPos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                } else if (eastChest) {
                    this.setState(worldIn, eastPos, state.func_177226_a((IProperty)field_176459_a, (Comparable)corrected), 3);
                }
            }
        } else {
            if (northChest) {
                this.setState(worldIn, northPos, state, 3);
            } else {
                this.setState(worldIn, southPos, state, 3);
            }
            worldIn.func_180501_a(pos, state, 3);
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileCustomChest) {
            TileCustomChest chest = (TileCustomChest)te;
            if (stack.func_82837_s()) {
                chest.func_190575_a(stack.func_82833_r());
            }
            chest.chestType = myType;
        }
        this.func_176213_c(worldIn, pos, state);
    }

    public void setState(World worldIn, BlockPos pos, IBlockState state, int flag) {
        TileEntity te = worldIn.func_175625_s(pos);
        worldIn.func_180501_a(pos, state, flag);
        if (te != null) {
            te.func_145829_t();
            worldIn.func_175690_a(pos, te);
            if (te instanceof TileCustomChest) {
                ((TileCustomChest)te).field_145984_a = false;
            }
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return this.field_149956_a == VariedChests.CUSTOM_TYPE_QUARK_TRAP;
    }

    @Deprecated
    public IBlockState func_176455_e(World worldIn, BlockPos pos, IBlockState state) {
        return state;
    }

    @Deprecated
    public IBlockState func_176458_f(World worldIn, BlockPos pos, IBlockState state) {
        return this.correctFacing(worldIn, pos, state, VariedChests.ChestType.NONE);
    }

    public IBlockState correctFacing(World worldIn, BlockPos pos, IBlockState state, VariedChests.ChestType myType) {
        EnumFacing facing = null;
        for (EnumFacing horizFace : EnumFacing.Plane.HORIZONTAL) {
            if (this.getCustomType((IBlockAccess)worldIn, pos.func_177972_a(horizFace)) == myType) {
                return state;
            }
            if (!worldIn.func_180495_p(pos.func_177972_a(horizFace)).func_185913_b()) continue;
            if (facing != null) {
                facing = null;
                break;
            }
            facing = horizFace;
        }
        if (facing != null) {
            return state.func_177226_a((IProperty)field_176459_a, (Comparable)facing.func_176734_d());
        }
        EnumFacing enumfacing2 = (EnumFacing)state.func_177229_b((IProperty)field_176459_a);
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176746_e();
        }
        if (worldIn.func_180495_p(pos.func_177972_a(enumfacing2)).func_185913_b()) {
            enumfacing2 = enumfacing2.func_176734_d();
        }
        return state.func_177226_a((IProperty)field_176459_a, (Comparable)enumfacing2);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public boolean isDoubleChest(World worldIn, BlockPos pos, VariedChests.ChestType myType) {
        if (this.getCustomType((IBlockAccess)worldIn, pos) != myType) {
            return false;
        }
        VariedChests.ChestType theType = this.getCustomType((IBlockAccess)worldIn, pos);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (this.getCustomType((IBlockAccess)worldIn, pos.func_177972_a(enumfacing)) != theType) continue;
            return true;
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
        if (te instanceof TileCustomChest) {
            te.func_145843_s();
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCustomChest();
    }

    public VariedChests.ChestType getCustomType(IBlockAccess source, BlockPos pos) {
        TileEntity te;
        if (source.func_180495_p(pos).func_177230_c() == this && (te = source.func_175625_s(pos)) instanceof TileCustomChest) {
            return ((TileCustomChest)te).chestType;
        }
        return VariedChests.ChestType.NONE;
    }

    public VariedChests.ChestType getCustomType(ItemStack stack) {
        return ((VariedChests.ChestType[])VariedChests.ChestType.class.getEnumConstants())[Math.min(5, stack.func_77952_i() + 1)];
    }

    public ItemStack setCustomType(ItemStack stack, VariedChests.ChestType type) {
        stack.func_77964_b(type.ordinal() - 1);
        return stack;
    }

    public ILockableContainer func_189418_a(World world, BlockPos pos, boolean locked) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileCustomChest)) {
            return null;
        }
        TileCustomChest myChest = (TileCustomChest)tile;
        VariedChests.ChestType myType = ((TileCustomChest)tile).chestType;
        if (!locked && this.isBlocked(world, pos)) {
            return null;
        }
        for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos adjPos = pos.func_177972_a(facing);
            TileEntity adjTile = world.func_175625_s(adjPos);
            if (world.func_180495_p(adjPos).func_177230_c() != this || !(adjTile instanceof TileCustomChest) || ((TileCustomChest)adjTile).chestType != myType) continue;
            if (this.isBlocked(world, adjPos)) {
                return null;
            }
            if (facing != EnumFacing.WEST && facing != EnumFacing.NORTH) {
                myChest = new InventoryLargeChest("container.chestDouble", (ILockableContainer)myChest, (ILockableContainer)((TileCustomChest)adjTile));
                continue;
            }
            myChest = new InventoryLargeChest("container.chestDouble", (ILockableContainer)((TileCustomChest)adjTile), (ILockableContainer)myChest);
        }
        return myChest;
    }

    private boolean isBlocked(World worldIn, BlockPos pos) {
        return this.isBelowSolidBlock(worldIn, pos) || this.isOcelotSittingOnChest(worldIn, pos);
    }

    private boolean isBelowSolidBlock(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN);
    }

    private boolean isOcelotSittingOnChest(World worldIn, BlockPos pos) {
        for (Entity entity : worldIn.func_72872_a(EntityOcelot.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            EntityOcelot cat = (EntityOcelot)entity;
            if (!cat.func_70906_o()) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>(Collections.singletonList(this.setCustomType(new ItemStack((Block)this, 1), this.getCustomType(world, pos))));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.setCustomType(new ItemStack((Block)this, 1), this.getCustomType((IBlockAccess)world, pos));
    }
}

