/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.automation.feature;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import vazkii.quark.base.module.ConfigHelper;
import vazkii.quark.base.module.Feature;

public class DispensersPlaceSeeds
extends Feature {
    Map<Item, IBlockState> customSeeds;

    @Override
    public void setupConfig() {
        ConfigHelper.needsRestart = true;
        String[] customSeedsArr = this.loadPropStringList("Custom Seeds", "Add seeds from other mods here, in the following format: mod:seed=mod:block:meta. Set meta to -1 to just place the default.", new String[0]);
        this.customSeeds = new HashMap<Item, IBlockState>();
        for (String s : customSeedsArr) {
            String[] tokens = s.split("=");
            if (tokens.length != 2) continue;
            String key = tokens[0];
            String value = tokens[1];
            Item item = Item.func_111206_d((String)key);
            if (item == null || (tokens = value.split(":")).length != 3) continue;
            try {
                value = tokens[0] + ":" + tokens[1];
                int meta = Integer.parseInt(tokens[2]);
                Block block = Block.func_149684_b((String)value);
                if (block == null) continue;
                if (meta == -1) {
                    this.customSeeds.put(item, block.func_176223_P());
                    continue;
                }
                this.customSeeds.put(item, block.func_176203_a(meta));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151014_N, (Object)new BehaviourSeeds(Blocks.field_150464_aj));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151174_bG, (Object)new BehaviourSeeds(Blocks.field_150469_bN));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151172_bF, (Object)new BehaviourSeeds(Blocks.field_150459_bM));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151075_bm, (Object)new BehaviourSeeds(Blocks.field_150388_bm));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151080_bb, (Object)new BehaviourSeeds(Blocks.field_150393_bb));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151081_bc, (Object)new BehaviourSeeds(Blocks.field_150394_bc));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_185163_cU, (Object)new BehaviourSeeds(Blocks.field_185773_cZ));
        BlockDispenser.field_149943_a.func_82595_a((Object)Item.func_150898_a((Block)Blocks.field_185766_cS), (Object)new BehaviourSeeds(Blocks.field_185766_cS));
        BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151100_aR, (Object)new BehaviourCocoaBeans((IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)Items.field_151100_aR)));
        for (Item i : this.customSeeds.keySet()) {
            BlockDispenser.field_149943_a.func_82595_a((Object)i, (Object)new BehaviourSeeds(this.customSeeds.get(i)));
        }
    }

    @Override
    public String[] getIncompatibleMods() {
        return new String[]{"Botania"};
    }

    public class BehaviourCocoaBeans
    extends BehaviorDefaultDispenseItem {
        IBehaviorDispenseItem vanillaBehaviour;

        public BehaviourCocoaBeans(IBehaviorDispenseItem vanilla) {
            this.vanillaBehaviour = vanilla;
        }

        public ItemStack func_82487_b(IBlockSource par1IBlockSource, ItemStack par2ItemStack) {
            if (par2ItemStack.func_77952_i() == EnumDyeColor.BROWN.func_176767_b()) {
                BlockPos logPos;
                Block block = Blocks.field_150375_by;
                EnumFacing facing = (EnumFacing)par1IBlockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                BlockPos pos = par1IBlockSource.func_180699_d().func_177972_a(facing);
                World world = par1IBlockSource.func_82618_k();
                IBlockState logState = world.func_180495_p(logPos = pos.func_177972_a(facing));
                if (logState.func_177230_c() == Blocks.field_150364_r && logState.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE && world.func_175623_d(pos) && block.func_176196_c(world, pos)) {
                    world.func_175656_a(pos, block.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing));
                    par2ItemStack.func_190918_g(1);
                    return par2ItemStack;
                }
            }
            return this.vanillaBehaviour.func_82482_a(par1IBlockSource, par2ItemStack);
        }
    }

    public class BehaviourSeeds
    extends BehaviorDefaultDispenseItem {
        private final IBlockState placeState;

        public BehaviourSeeds(Block block) {
            this(block.func_176223_P());
        }

        public BehaviourSeeds(IBlockState state) {
            this.placeState = state;
        }

        public ItemStack func_82487_b(IBlockSource par1IBlockSource, ItemStack par2ItemStack) {
            EnumFacing facing = (EnumFacing)par1IBlockSource.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos pos = par1IBlockSource.func_180699_d().func_177972_a(facing);
            World world = par1IBlockSource.func_82618_k();
            if (world.func_175623_d(pos) && this.placeState.func_177230_c().func_176196_c(world, pos)) {
                world.func_175656_a(pos, this.placeState);
                par2ItemStack.func_190918_g(1);
                return par2ItemStack;
            }
            return super.func_82487_b(par1IBlockSource, par2ItemStack);
        }
    }
}

