/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.tileentities;

import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.item.ItemRegistry;
import java.util.Random;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityGroundTrap
extends TileEntity
implements ITickable {
    private ItemStackHandler itemstackhandler = new ItemStackHandler(19);
    public int runTime = 0;
    public int currentBeeRunTime = 0;
    public int produceTime = 0;

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemstackhandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemstackhandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("Items"));
        this.runTime = compound.func_74765_d("RunTime");
        this.produceTime = compound.func_74765_d("ProduceTime");
        this.currentBeeRunTime = this.getRunTime(this.itemstackhandler.getStackInSlot(1));
    }

    @MethodsReturnNonnullByDefault
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("RunTime", (short)this.runTime);
        compound.func_74777_a("ProduceTime", (short)this.produceTime);
        compound.func_74782_a("Items", (NBTBase)this.itemstackhandler.serializeNBT());
        return compound;
    }

    public int countFlowers() {
        int radius = 2;
        int count = 0;
        int varX = this.field_174879_c.func_177958_n();
        int varY = this.field_174879_c.func_177956_o();
        int varZ = this.field_174879_c.func_177952_p();
        for (int offsetX = -radius; offsetX <= radius; ++offsetX) {
            for (int offsetZ = -radius; offsetZ <= radius; ++offsetZ) {
                Block blockAtCoords;
                BlockPos pos;
                if (offsetX * offsetX + offsetZ * offsetZ > radius * radius || offsetX == -(radius - 1) && offsetZ == -(radius - 1) || offsetX == radius - 1 && offsetZ == radius - 1 || offsetX == radius - 1 && offsetZ == -(radius - 1) || offsetX == -(radius - 1) && offsetZ == radius - 1 || !this.field_145850_b.func_175667_e(pos = new BlockPos(varX + offsetX, varY, varZ + offsetZ)) || !((blockAtCoords = this.field_145850_b.func_180495_p(pos).func_177230_c()) instanceof BlockDirt) && !(blockAtCoords instanceof BlockGrass)) continue;
                ++count;
            }
        }
        return count;
    }

    public void func_73660_a() {
        boolean isRunning = this.runTime > 0;
        boolean needsUpdate = false;
        if (isRunning) {
            --this.runTime;
        }
        ItemStack queenBee = this.itemstackhandler.getStackInSlot(18);
        if (!this.field_145850_b.field_72995_K) {
            if (this.runTime == 0 && this.canRun()) {
                this.currentBeeRunTime = this.runTime = this.getRunTime(queenBee);
                if (this.runTime > 0) {
                    needsUpdate = true;
                    if (!queenBee.func_190926_b()) {
                        queenBee.func_190918_g(1);
                    }
                }
            }
            if (this.canRun()) {
                ++this.produceTime;
                if ((double)this.produceTime >= Math.floor(this.getRunTime())) {
                    this.produceTime = 0;
                    this.run();
                    needsUpdate = true;
                }
            } else {
                this.produceTime = 0;
            }
            if (isRunning != this.runTime > 0) {
                needsUpdate = true;
            }
        }
        if (needsUpdate) {
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 3);
        }
    }

    private boolean canRun() {
        if (!this.itemstackhandler.getStackInSlot(18).func_190926_b()) {
            return (this.itemstackhandler.getStackInSlot(18).func_77973_b() == ItemRegistry.grainbaitItem || this.itemstackhandler.getStackInSlot(18).func_77973_b() == ItemRegistry.fruitbaitItem || this.itemstackhandler.getStackInSlot(18).func_77973_b() == ItemRegistry.veggiebaitItem) && this.countFlowers() >= 5;
        }
        return false;
    }

    public void run() {
        ItemStack itemProduced = this.getComb();
        for (int i = 0; i < 18; ++i) {
            if (!this.itemstackhandler.getStackInSlot(i).func_190926_b()) continue;
            this.itemstackhandler.setStackInSlot(i, itemProduced.func_77946_l());
            break;
        }
    }

    public ItemStack getComb() {
        Random rnd = new Random();
        if (!this.itemstackhandler.getStackInSlot(18).func_190926_b()) {
            int rndnum;
            if (this.itemstackhandler.getStackInSlot(18).func_77973_b() == ItemRegistry.grainbaitItem) {
                rndnum = rnd.nextInt(11);
                switch (rndnum) {
                    case 0: {
                        return new ItemStack(ItemRegistry.turkeyrawItem, 1, 0);
                    }
                    case 1: {
                        return new ItemStack(Items.field_151082_bd, 1, 0);
                    }
                    case 2: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 3: {
                        return new ItemStack(Items.field_151116_aA, 1, 0);
                    }
                    case 4: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                    case 5: {
                        return new ItemStack(Items.field_151110_aK, 1, 0);
                    }
                    case 6: {
                        return new ItemStack(Items.field_151103_aS, 1, 0);
                    }
                    case 7: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 8: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 9: {
                        return new ItemStack(ItemRegistry.turkeyrawItem, 1, 0);
                    }
                    case 10: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                }
            }
            if (this.itemstackhandler.getStackInSlot(18).func_77973_b() == ItemRegistry.fruitbaitItem) {
                rndnum = rnd.nextInt(11);
                switch (rndnum) {
                    case 0: {
                        return new ItemStack(Items.field_179558_bo, 1, 0);
                    }
                    case 1: {
                        return new ItemStack(Items.field_151116_aA, 1, 0);
                    }
                    case 2: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                    case 3: {
                        return new ItemStack(Items.field_151110_aK, 1, 0);
                    }
                    case 4: {
                        return new ItemStack(Items.field_151103_aS, 1, 0);
                    }
                    case 5: {
                        return new ItemStack(Items.field_179556_br, 1, 0);
                    }
                    case 6: {
                        return new ItemStack(Items.field_179555_bs, 1, 0);
                    }
                    case 7: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 8: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 9: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 10: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                }
            }
            if (this.itemstackhandler.getStackInSlot(18).func_77973_b() == ItemRegistry.veggiebaitItem) {
                rndnum = rnd.nextInt(11);
                switch (rndnum) {
                    case 0: {
                        return new ItemStack(ItemRegistry.venisonrawItem, 1, 0);
                    }
                    case 1: {
                        return new ItemStack(Items.field_179561_bm, 1, 0);
                    }
                    case 2: {
                        return new ItemStack(Items.field_151147_al, 1, 0);
                    }
                    case 3: {
                        return new ItemStack(Items.field_151116_aA, 1, 0);
                    }
                    case 4: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                    case 5: {
                        return new ItemStack(Items.field_151110_aK, 1, 0);
                    }
                    case 6: {
                        return new ItemStack(Items.field_151103_aS, 1, 0);
                    }
                    case 7: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 8: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 9: {
                        return new ItemStack(Items.field_151076_bf, 1, 0);
                    }
                    case 10: {
                        return new ItemStack(Items.field_151008_G, 1, 0);
                    }
                }
            }
        }
        return null;
    }

    int getRunTime(ItemStack stack) {
        if (!(stack.func_190926_b() || stack.func_77973_b() != ItemRegistry.grainbaitItem && stack.func_77973_b() != ItemRegistry.fruitbaitItem && stack.func_77973_b() != ItemRegistry.veggiebaitItem)) {
            return 3200;
        }
        return 0;
    }

    private int getRunTime() {
        int radius = 2;
        int varX = this.field_174879_c.func_177958_n();
        int varY = this.field_174879_c.func_177956_o();
        int varZ = this.field_174879_c.func_177952_p();
        int speed = 3500;
        for (int offsetX = -2; offsetX <= 2; ++offsetX) {
            for (int offsetZ = -2; offsetZ <= 2; ++offsetZ) {
                BlockPos pos;
                if (offsetX * offsetX + offsetZ * offsetZ > 4 || offsetX == -3 && offsetZ == -3 || offsetX == 1 && offsetZ == 1 || offsetX == 1 && offsetZ == -3 || offsetX == -3 && offsetZ == 1 || !this.field_145850_b.func_175667_e(pos = new BlockPos(varX + offsetX, varY, varZ + offsetZ))) continue;
                Block blockAtCoords = this.field_145850_b.func_180495_p(pos).func_177230_c();
                if (blockAtCoords instanceof BlockDirt || blockAtCoords instanceof BlockGrass) {
                    speed = (int)((double)speed * 0.95);
                }
                if (blockAtCoords != BlockRegistry.groundtrap) continue;
                speed = (int)((double)speed / 0.85);
            }
        }
        return speed;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public String getGuiID() {
        return "harvestcraft:groundtrap";
    }
}

