/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.loottables;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.CropRegistry;
import com.pam.harvestcraft.item.ItemRegistry;
import com.pam.harvestcraft.loottables.CustomLootPool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.KilledByPlayer;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;

public class LootHelper {
    public static final Set<CustomLootPool> additionalLootPools = new HashSet<CustomLootPool>();

    private static LootEntryItem createLootEntryItem(Item item, int weight, int quality) {
        return LootHelper.createLootEntryItem(item, weight, quality, new LootFunction[0], new LootCondition[0]);
    }

    private static LootEntryItem createLootEntryItem(Item item, int weight, int quality, LootFunction[] lootFunctions, LootCondition ... lootConditions) {
        return new LootEntryItem(item, weight, quality, lootFunctions, lootConditions, "harvestcraft." + item.func_77658_a());
    }

    static {
        ArrayList<LootEntryItem> gameplayFishingJunkEntries = new ArrayList<LootEntryItem>();
        gameplayFishingJunkEntries.add(LootHelper.createLootEntryItem((Item)CropRegistry.getFood("seaweed"), 10, 0));
        additionalLootPools.add(new CustomLootPool(LootTableList.field_186388_am, gameplayFishingJunkEntries, false));
        ArrayList<LootEntryItem> gameplayFishingFishEntries = new ArrayList<LootEntryItem>();
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.anchovyrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.bassrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.carprawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.catfishrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.charrrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.eelrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.greenheartfishItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.grouperrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.herringrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.jellyfishrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.mudfishrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.octopusrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.perchrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.snapperrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.tilapiarawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.troutrawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.tunarawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.walleyerawItem, 25, 0));
        gameplayFishingFishEntries.add(LootHelper.createLootEntryItem(ItemRegistry.sardinerawItem, 25, 0));
        additionalLootPools.add(new CustomLootPool(LootTableList.field_186390_ao, gameplayFishingFishEntries, false));
        if (HarvestCraft.config.squiddropCalamari) {
            ArrayList<LootEntryItem> squidEntries = new ArrayList<LootEntryItem>();
            squidEntries.add(LootHelper.createLootEntryItem(ItemRegistry.calamarirawItem, 50, 0, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f, 2.0f))}, new LootCondition[]{new KilledByPlayer(false)}));
            additionalLootPools.add(new CustomLootPool(LootTableList.field_186381_af, squidEntries, true));
        }
    }
}

