/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.blocks.growables;

import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import com.pam.harvestcraft.blocks.growables.PamCropGrowable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPamFruit
extends Block
implements IGrowable,
PamCropGrowable {
    private static final int MATURE_AGE = 2;
    private final BlockPamSapling sapling;
    private final Item fruitItem;
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
    public String BASE_STAGE_ID = null;

    public BlockPamFruit(BlockPamSapling sapling, Item fruit) {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.sapling = sapling;
        this.fruitItem = fruit;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public PropertyInteger getAgeProperty() {
        return AGE;
    }

    public Item getFruitItem() {
        if (this.fruitItem == null) {
            FMLLog.bigWarning((String)"Cannot get fruit %s.", (Object[])new Object[]{this.func_149739_a()});
        }
        return this.fruitItem;
    }

    public BlockPamSapling getSapling() {
        if (this.sapling == null) {
            FMLLog.bigWarning((String)"Cannot get sapling for fruit %s.", (Object[])new Object[]{this.func_149739_a()});
        }
        return this.sapling;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (this.func_176201_c(blockState) >= 2) {
            return 0.0f;
        }
        return 5.0f;
    }

    public String getStageId(int stage) {
        if (this.BASE_STAGE_ID == null) {
            this.BASE_STAGE_ID = this.func_149739_a().replaceFirst("pam", "").replaceFirst("tile.", "").toLowerCase() + "_stage";
        }
        return this.BASE_STAGE_ID + stage;
    }

    @Override
    public int getMatureAge() {
        return 2;
    }

    @Override
    public boolean isMature(IBlockState state) {
        return this.func_176201_c(state) >= 2;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState blockState, World worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.func_176201_c(state) >= 2) {
            drops.add(new ItemStack(this.getFruitItem(), 1));
            drops.add(new ItemStack(this.getFruitItem(), 1));
        }
        return drops;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Block leafBlock = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return this.isSuitableSoilBlock(leafBlock);
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.validatePosition(worldIn, pos);
    }

    public void validatePosition(World world, BlockPos pos) {
        if (!this.func_176196_c(world, pos)) {
            world.func_175698_g(pos);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private boolean isSuitableSoilBlock(Block leafBlock) {
        return leafBlock == Blocks.field_150362_t || leafBlock == Blocks.field_150361_u;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)AGE);
        if (i < 2 && rand.nextInt(25) == 0) {
            state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1));
            worldIn.func_180501_a(pos, state, 2);
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    private void grow(World worldIn, BlockPos pos, IBlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)AGE) + MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)1, (int)2);
        if (i > 2) {
            i = 2;
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 2;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state);
    }
}

