/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.addons;

import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import com.pam.harvestcraft.blocks.growables.PamCropGrowable;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockPotato;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RightClickHarvesting {
    public static final RightClickHarvesting instance = new RightClickHarvesting();

    private RightClickHarvesting() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (!HarvestCraft.config.enableEasyHarvest) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        IBlockState blockState = event.getWorld().func_180495_p(event.getPos());
        if (blockState.func_177230_c() instanceof BlockCrops) {
            RightClickHarvesting.harvestCrops(blockState, event.getEntityPlayer(), event.getWorld(), event.getPos());
        }
        if (blockState.func_177230_c() instanceof BlockPamFruit || blockState.func_177230_c() instanceof BlockPamFruitLog) {
            RightClickHarvesting.harvestFruit(blockState, event.getEntityPlayer(), event.getWorld(), event.getPos());
        }
    }

    private static void harvestCrops(IBlockState blockState, EntityPlayer player, World world, BlockPos blockPos) {
        BlockCrops crops = (BlockCrops)blockState.func_177230_c();
        if (crops.func_185525_y(blockState)) {
            ItemStack stack = player.func_184614_ca();
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            List drops = crops.getDrops((IBlockAccess)world, blockPos, blockState, fortune);
            Item seedItem = crops.func_180660_a(blockState, world.field_73012_v, fortune);
            if (seedItem != null) {
                Iterator iterator = drops.iterator();
                while (iterator.hasNext()) {
                    ItemStack drop = (ItemStack)iterator.next();
                    if (drop.func_77973_b() == seedItem && !(crops instanceof BlockCarrot) && !(crops instanceof BlockPotato)) continue;
                    iterator.remove();
                    break;
                }
            }
            ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)blockPos, (IBlockState)blockState, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
            world.func_175656_a(blockPos, crops.func_185528_e(0));
            for (ItemStack drop : drops) {
                RightClickHarvesting.dropItem(drop, world, blockPos);
            }
        }
    }

    private static void harvestFruit(IBlockState blockState, EntityPlayer player, World world, BlockPos blockPos) {
        PamCropGrowable blockPamFruit = (PamCropGrowable)blockState.func_177230_c();
        if (blockPamFruit.isMature(blockState)) {
            ItemStack stack = player.func_184614_ca();
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            List<ItemStack> drops = blockPamFruit.getDrops((IBlockAccess)world, blockPos, blockState, fortune);
            if (drops.size() > 0) {
                drops.remove(drops.size() - 1);
            }
            ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (BlockPos)blockPos, (IBlockState)blockState, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)player);
            world.func_180501_a(blockPos, blockState.func_177226_a((IProperty)blockPamFruit.getAgeProperty(), (Comparable)Integer.valueOf(0)), 3);
            for (ItemStack drop : drops) {
                RightClickHarvesting.dropItem(drop, world, blockPos);
            }
        }
    }

    private static void dropItem(ItemStack itemStack, World world, BlockPos pos) {
        if (world.restoringBlockSnapshots || world.field_72995_K) {
            return;
        }
        float f = 0.5f;
        double d0 = (double)(world.field_73012_v.nextFloat() * f) + 0.25;
        double d1 = (double)(world.field_73012_v.nextFloat() * f) + 0.25;
        double d2 = (double)(world.field_73012_v.nextFloat() * f) + 0.25;
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, itemStack);
        entityItem.func_174869_p();
        world.func_72838_d((Entity)entityItem);
    }
}

